use master
GO

set nocount on 

declare @ProjectPayload01 nvarchar(max) = N'
-- 2425 DEV-94653
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[IS_sp_UpdateOrCreateRespondent]'') AND type in (N''P'', N''	PC''))
DROP PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondent]
'

declare @ProjectPayload02 nvarchar(max) = N'
CREATE  PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondent]
@ProjectId int,
@UserId int,
@CollectMode int,
@ResRespondent varchar(10),
@ResLanguage int,
@ResTimeZone int,
@ResCallbackDate datetime,
@ManualDialing int,
@Resphone nvarchar(20),
@ResLastCallDate datetime,
@ResCompleted bit,
@ResCodeResult varchar(2),
@ResPin varchar(100),
@ResLastCompQuest int,
@ResActive bit,
@panelistId int,
@LastA4SHistoricEntryDate datetime,
@DialingMode int
AS
BEGIN
       DECLARE @previousLastCallDate datetime
       SELECT @previousLastCallDate = ISNULL(ResLastCallDate,0) FROM Respondent WHERE ResRespondent = @ResRespondent

       UPDATE Respondent SET
              ProjectId = @ProjectId,
              CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
              ModifiedBy = @UserId,
              Modified = GETUTCDATE(),
              ResLanguage = @ResLanguage,
              ResTimeZone = @ResTimeZone,
              ResLastCallDate = CASE WHEN @ResLastCallDate IS NULL OR @ResLastCallDate < ResLastCallDate THEN ResLastCallDate 
									 ELSE @ResLastCallDate END,
              ResCompleted = @ResCompleted,
              ResLastCompQuest = @ResLastCompQuest,
              ResActive = @ResActive,
              panelistId = @panelistId,
			  ResCompletedDate = CASE WHEN ResCompleted = 0 AND @ResCompleted = 1 THEN GETUTCDATE() 
								      WHEN ResCompleted = 1 AND @ResCompleted = 0 THEN NULL
								      ELSE ResCompletedDate END
       WHERE ResRespondent = @ResRespondent
       IF @@ROWCOUNT = 0
       BEGIN
	          DECLARE @priority INT = 0

			  IF @ResCodeResult is null OR LEN(@ResCodeResult) = 0 
			  BEGIN
					SELECT @priority=INSVALUE FROM Installation WHERE INSSECTION=''RULES'' AND INSIDENT=''PRIORITY OF FRESH'' 								
					SET @priority = IsNull(@priority, 9)
			  END
			 	
              -- A4S to CC3 synchronization: Set ResBlocked=1 initially (following CATI importation mechanics)
              -- Cases will be unblocked later during quota computation if they don''t belong to closed strata
              INSERT INTO respondent (ResRespondent, ProjectId, CollectMode, ModifiedBy, Modified, ResLanguage, ResTimeZone, ResCallbackDate,
                                                       ResLastCallDate,ResCompleted, ResSeed, ResCodeResult, ResLastCompQuest, ResActive,
                                                       ResIntervCall, ResCallCount, ResVersion, ResPriority, ResConfidPhone, ResWaveNo, ResBlocked, ResCompPredictive,
                                                       ResCall, ResMonitored, ResPreviousCallDate, ResWaveImportNo, panelistId, ResNextIntervCall, Resphone, ResCompletedDate)
              VALUES (@ResRespondent, @ProjectId, CASE WHEN @CollectMode < 0 THEN 0 ELSE @CollectMode END, @UserId, GETUTCDATE(), @ResLanguage, @ResTimeZone, isnull(@ResCallbackDate,0),
                           @ResLastCallDate, @ResCompleted, CAST(@ResRespondent AS FLOAT), @ResCodeResult, @ResLastCompQuest, @ResActive,
                           '''', 0, '''', @priority, 0, 0, 1, 0,
                           0, 0, 0, 0, @panelistId, '''',isnull(@Resphone,'''') ,CASE WHEN @ResCompleted = 1 THEN GETUTCDATE() ELSE NULL END  )            
       END

	   IF @ResCallbackDate IS NOT NULL
              UPDATE Respondent SET ResCallbackDate=@ResCallbackDate WHERE ResRespondent=@ResRespondent

       IF @ManualDialing IS NOT NULL
              UPDATE Respondent SET ManualDialing=@ManualDialing WHERE ResRespondent=@ResRespondent AND ManualDialing=0

       IF @ResCodeResult is not null AND LEN(@ResCodeResult) > 0 AND @previousLastCallDate <= @LastA4SHistoricEntryDate
              UPDATE Respondent SET ResCodeResult=@ResCodeResult WHERE ResRespondent=@ResRespondent

       IF @DialingMode is not null 
              UPDATE Respondent SET DialingMode=@DialingMode WHERE ResRespondent=@ResRespondent

	   IF @Resphone is not null
              UPDATE Respondent SET Resphone=@Resphone WHERE ResRespondent=@ResRespondent       
       
	   IF @ResPin is null or @ResPin = ''''
              DELETE FROM RespondentPin WHERE rspRespondent=@ResRespondent
       ELSE
       BEGIN


   -- Check for duplicate first
   IF EXISTS( SELECT 1 FROM [RespondentPIN]  WHERE RspPIN = @ResPin AND RspRespondent <> @ResRespondent)
     DELETE FROM RespondentPin WHERE rspRespondent= (SELECT RspRespondent FROM [RespondentPIN]  WHERE RspPIN = @ResPin)
              UPDATE RespondentPin SET rspPin=@ResPin, ProjectId = @ProjectId, ModifiedBy = @UserId, Modified = GETUTCDATE()
              WHERE rspRespondent=@ResRespondent
              IF @@rowcount = 0
                     INSERT into RespondentPin values(@resRespondent,@resPin,@projectId,@userId,GETUTCDATE())
       END
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @TotalProjectsDB int,
        @ThisProjectsDB nvarchar(128),
		@ProjectsDBCounter int = 0, 
		@ProjectsDBCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

		
insert into #DB 
SELECT [name] AS DBName, 0 AS Processed FROM sys.databases WHERE [name] like 'VOXCO_Project_%';
	     
select @TotalProjectsDB = count(*) 
	    from #DB
	
set @ProjectsDBCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
open @ProjectsDBCursor
fetch next from @ProjectsDBCursor into @ThisProjectsDB
while @@FETCH_STATUS = 0 begin
	select @ProjectsDBCounter += 1
	select @DBSQL = @ThisProjectsDB + N'.sys.sp_executesql'
	select @StatusMessage = 'Updating Project database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ProjectsDBCounter / @TotalProjectsDB
	raiserror (@StatusMessage, 0, 1, @ThisProjectsDB, @ProjectsDBCounter, @TotalProjectsDB, @StatusPercent) with nowait
	
	SELECT 'Updating Project DB: ' + @ThisProjectsDB
        print 'Project Payload 1'
        if isnull(@ProjectPayload01, '') <> '' exec @DBSQL @ProjectPayload01

        print 'Project Payload 2'
        if isnull(@ProjectPayload02, '') <> '' exec @DBSQL @ProjectPayload02

	print 'All Project Payload done!'

	update #DB set Processed = 1 where current of @ProjectsDBCursor
	fetch next from @ProjectsDBCursor into @ThisProjectsDB
end

close @ProjectsDBCursor
deallocate @ProjectsDBCursor

--select * from #DB

drop table #DB

